function XMLWriter()
{
    this.XML=[];
    this.Nodes=[];
    this.State="";
    this.FormatXML = function(Str)
    {
        if (Str)
            return Str.replace(/&/g, "&amp;").replace(/\"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
        return ""
    }
    this.BeginNode = function(Name)
    {
        if (!Name) return;
        if (this.State=="beg") this.XML.push(">\n");
        this.State="beg";
		for (i=0; i<this.Nodes.length; i++) {
			this.XML.push("\t");
		}
        this.Nodes.push(Name);
        this.XML.push("<"+Name);
    }
    this.EndNode = function()
    {
        if (this.State=="beg")
        {
            this.XML.push("/>\n");
            this.Nodes.pop();
        }
        else if (this.Nodes.length>0)
			for (i=1; i<this.Nodes.length; i++) {
				this.XML.push("\t");
			}
            this.XML.push("</"+this.Nodes.pop()+">\n");
        this.State="";
    }
    this.Attrib = function(Name, Value)
    {
        if (this.State!="beg" || !Name) return;
        this.XML.push(" "+Name+"=\""+this.FormatXML(Value)+"\"");
    }
    this.WriteString = function(Value)
    {
        if (this.State=="beg") this.XML.push(">");
        this.XML.push(this.FormatXML(Value));
        this.State="";
    }
    this.Node = function(Name, Value)
    {
        if (!Name) return;
        if (this.State=="beg") this.XML.push(">\n");
		for (i=0; i<this.Nodes.length; i++) {
			this.XML.push("\t");
		}
        this.XML.push((Value=="" || !Value)?"<"+Name+"/>\n":"<"+Name+">"+this.FormatXML(Value)+"</"+Name+">\n");
        this.State="";
    }
    this.Close = function()
    {
        while (this.Nodes.length>0) {
			for (i=1; i<this.Nodes.length; i++) {
				this.XML.push("\t");
			}
            this.EndNode();
		}
        this.State="closed";
    }
    this.ToString = function(){return this.XML.join("");}
}