// Add Learning Resource page

function validate() {
	var name = document.add_r.name.value;
	var desc = document.add_r.desc.value;
	var pathurl = document.add_r.pathurl.value;
	var topicsForm = document.add_r.topics;
	var topicsChecked = new Array;
	for (i = 0; i < topicsForm.length; i++) {
		if (topicsForm[i].checked == true) {
			topicsChecked.push(topicsForm[i].value);
		}
	}
	
	var error = false;
	var errorString = "";
	
	if (name == "") {
		error = true;
		errorString += "The name is invalid.";	
	}
	if (desc == "") {
		if (error == true) errorString += "\n";
		error = true;
		errorString += "The description is invalid.";	
	}
	if (topicsChecked.length <= 0) {
		if (error == true) errorString += "\n";
		error = true;
		errorString += "Please check at least one topic.";
	}
	if (pathurl == "") {
		if (error == true) errorString += "\n";
		error = true;
		errorString += "The Path - URL is invalid.";
	}
	
	if (error == true) {
		return alert(errorString);	
	} else {
		addSubmit();	
	}
}

function addSubmit() {
	loadXML();	
}
function loadXML() {
	var url = "lr.xml";
	var xml = new JKL.ParseXML(url);
	var data = xml.parse();
	parseXML(data);
}

function parseXML(xml) {
	// Collect data for XML Node creation
	var idArray = new Array;
	for (x in xml.learning_resources.resource) {
		var id = xml.learning_resources.resource[x].id;
		id = trimNumber(id);
		idArray.push(id);
	}
	var largest = Math.max.apply(Math, idArray);
	var newID = largest+1;
	
	var name = document.add_r.name.value;
	var desc = document.add_r.desc.value;
	var role = document.add_r.role.value;
	var topicsForm = document.add_r.topics;
	var topicsChecked = new Array;
	for (i = 0; i < topicsForm.length; i++) {
		if (topicsForm[i].checked == true) {
			topicsChecked.push(topicsForm[i].value);
		}
	}
	var format = document.add_r.format.value;
	var path = document.add_r.path.value;
	var pathother = document.add_r.pathother.value;
	var pathurl = document.add_r.pathurl.value;
	
	var XML=new XMLWriter();
	XML.BeginNode("learning_resources");
	XML.BeginNode("resource");
	XML.Node("id", String(newID));
	XML.Node("name", name);
	XML.Node("desc", desc);
	XML.Node("role", role);
	XML.BeginNode("topics");
	for (y=0; y<topicsChecked.length; y++) {
		XML.Node("topic", topicsChecked[y]);
	}
	XML.EndNode();
	XML.Node("format", format);
	XML.Node("path", path);
	XML.Node("pathother", pathother);
	XML.Node("pathurl", pathurl);
	XML.EndNode();
	XML.EndNode();
	XML.Close();
	
	var result = '<?xml version="1.0" encoding="iso-8859-1"?>\n' + XML.ToString();
	document.getElementById("ExampleOutput").value = result;
}


function search(theArray, searchStr) {
	var returnArray = false;
	for (i=0; i<theArray.length; i++) {
		if (typeof(searchStr) == 'function') {
			if (searchStr.test(theArray[i])) {
				if (!returnArray) { returnArray = [] }
					returnArray.push(i);
			}
		} else {
			if (theArray[i]===searchStr) {
				if (!returnArray) { returnArray = [] }
					returnArray.push(i);
			}
		}
	}
	return returnArray;
}

function trimNumber(s) {
	return s.replace(/^0+/, '');
}

Array.max = function(array){
    return Math.max.apply( Math, array );
};