// Learning Resources page
$(document).ready(function(){
	$("input").attr("checked", false);
	showLoading("");
	setTimeout("loadXML()",500);
	$("#send").click(function () {
		showLoading("");
		
		var topicsArray = $("#topics_form").children().serializeArray();
		var formatArray = $("#format_form").children().serializeArray();
		var topics = new Array;
		var formats = new Array;
		for (x in topicsArray) {
			topics.push(topicsArray[x]["value"]);
		}
		
		for (x in formatArray) {
			formats.push(formatArray[x]["value"]);
		}
		
		if (topics == "" && formats == "") {
			setTimeout("loadXML()",500);
			//loadXML();
		} else {
			setTimeout(function() { reloadXML(topics, formats);}, 500);
			//reloadXML(topics, formats);
		}
	});
});

function loadXML() {
	var url = "xml/lr.xml";
	var xml = new JKL.ParseXML(url);
	var data = xml.parse();
	parseXML(data);
}

function parseXML(xml) {
	var number = 0;
	var htmlStringToAdd = "";
	//for (x=100;x<112;x++) {
	for (x in xml.learning_resources.resource) {
		
		var topics = "";
		var topicsArray = new Array;
		if (xml.learning_resources.resource[x].topics.topic.length <= 4) {
			for (y in xml.learning_resources.resource[x].topics.topic) {
				var topic = xml.learning_resources.resource[x].topics.topic[y];
				topics += topic;
				if (y < (xml.learning_resources.resource[x].topics.topic.length-1)) {
					topics += " | ";
				}
				topicsArray.push(topic);
			}
		} else {
			var topic = xml.learning_resources.resource[x].topics.topic;
			topics += topic;
			topicsArray.push(topic);
		}
		
		if (usedRole == "CFP / CPFP / DCPE / DPE") {
			var PBOTopicsArray = new Array("Outils de placement de base", "Produits de placement", "Types de rgimes de placement", "Conformit gnrale", "Pertinence du produit");
			for (z in topicsArray) {
				if (search(PBOTopicsArray, topicsArray[z])) {
					var doTheSearch = true;
					break;
				} else {
					var doTheSearch = false;
				}
			}
		} else {
			var doTheSearch = true;
		}
		
		if (doTheSearch == true) {
		
			number++;
			var id = xml.learning_resources.resource[x].id;
			var format = xml.learning_resources.resource[x].format;
			var role = xml.learning_resources.resource[x].role;
			var name = xml.learning_resources.resource[x].name;
			
			
			var desc = xml.learning_resources.resource[x].desc;
			var pathname = xml.learning_resources.resource[x].pathname;
			if (pathname == undefined) {
				pathname = xml.learning_resources.resource[x].pathname2;
			}
			
			var pathtofollow = "";
			if (xml.learning_resources.resource[x].path2) {
				pathtofollow += xml.learning_resources.resource[x].path2;
			}
			if (xml.learning_resources.resource[x].path3) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path3;
			}
			if (xml.learning_resources.resource[x].path4) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path4;
			}
			if (xml.learning_resources.resource[x].path5) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path5;
			}
			if (xml.learning_resources.resource[x].path6) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path6;
			}
			
			var pathurl = xml.learning_resources.resource[x].pathurl;
			
			if (pathurl == undefined) {
				var linktotal = "<div class='link_title'>Path to follow:</div><div class='link'>" + pathtofollow + "</div><div style='clear: both;'></div><div class='link_title'>Link:</div><div class='link'>"+pathname+"</div><div style='clear: both;'></div>";		
			} else {
				var linktotal = "<div class='link_title'>Chemin  suivre:</div><div class='link'>" + pathtofollow + "</div><div style='clear: both;'></div><div class='link_title'>Lien:</div><div class='link'><a href='#' onClick='openCenteredWindow(\""+pathurl+"\");'>"+pathname+"</a></div><div style='clear: both;'></div>";	
			}
			
			htmlStringToAdd += 
				"<div class='resource' id='id_"+id+"'>" + 
					"<p>#" + number + ": <a href='#' onclick='changeState(\"box_"+id+"\", \"ec_"+id+"\");return false;'>"+name+"<img id='ec_"+id+"' src='images/arrow_collapse.gif' width='10' height='10' alt='Ouvrir' /></a></p>" +
					"<div class='answer' id='box_"+id+"'>" +
						"<div class='desc_title'>Description:</div><div class='desc'>"+desc+"</div><div style='clear: both;'></div><div class='topics_title'>Sujet(s):</div><div class='format'>"+topics+"</div><div style='clear: both;'></div><div class='format_title'>Type:</div><div class='format'>"+format+"</div><div style='clear: both;'></div>"+ linktotal +
					"</div>" +
				"</div>";
				
		}
	}
	document.getElementById("resources_list").innerHTML = htmlStringToAdd;
	putLRTitle(number);
}

function reloadXML(topics, formats) {
	var url = "xml/lr.xml";
	var xml = new JKL.ParseXML(url);
	var data = xml.parse();
	parseXMLResults(data, topics, formats);
}

function parseXMLResults(xml, topicsSearch, formatsSearch) {
	var number = 0;
	var htmlStringToAdd = "";
	for (x in xml.learning_resources.resource) {
		var topics = "";
		var topicsArray = new Array;
		if (xml.learning_resources.resource[x].topics.topic.length <= 4) {
			for (y in xml.learning_resources.resource[x].topics.topic) {
				var topic = xml.learning_resources.resource[x].topics.topic[y];
				topics += topic;
				if (y < (xml.learning_resources.resource[x].topics.topic.length-1)) {
					topics += " | ";
				}
				topicsArray.push(topic);
			}
		} else {
			var topic = xml.learning_resources.resource[x].topics.topic;
			topics += topic;
			topicsArray.push(topic);
		}
		if (usedRole == "CFP / CPFP / DCPE / DPE") {
			var PBOTopicsArray = new Array("Outils de placement de base", "Produits de placement", "Types de rgimes de placement", "Conformit gnrale", "Pertinence du produit");
			for (z in topicsArray) {
				if (search(PBOTopicsArray, topicsArray[z])) {
					var doTheSearch = true;
					break;
				} else {
					var doTheSearch = false;
				}
			}
		} else {
			var doTheSearch = true;
		}
		
		if (doTheSearch == true) {
			
			var id = xml.learning_resources.resource[x].id;
			var format = xml.learning_resources.resource[x].format;
			var role = xml.learning_resources.resource[x].role;
			var name = xml.learning_resources.resource[x].name;
			var desc = xml.learning_resources.resource[x].desc;
			var pathname = xml.learning_resources.resource[x].pathname;
			if (pathname == undefined) {
				pathname = xml.learning_resources.resource[x].pathname2;
			}
			
			var pathtofollow = "";
			if (xml.learning_resources.resource[x].path2) {
				pathtofollow += xml.learning_resources.resource[x].path2;
			}
			if (xml.learning_resources.resource[x].path3) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path3;
			}
			if (xml.learning_resources.resource[x].path4) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path4;
			}
			if (xml.learning_resources.resource[x].path5) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path5;
			}
			if (xml.learning_resources.resource[x].path6) {
				pathtofollow += " > " + xml.learning_resources.resource[x].path6;
			}
			
			var pathurl = xml.learning_resources.resource[x].pathurl;
			
			if (pathurl == undefined) {
				var linktotal = "<div class='link_title'>Path to follow:</div><div class='link'>" + pathtofollow + "</div><div style='clear: both;'></div><div class='link_title'>Link:</div><div class='link'>"+pathname+"</div><div style='clear: both;'></div>";		
			} else {
				var linktotal = "<div class='link_title'>Chemin  suivre:</div><div class='link'>" + pathtofollow + "</div><div style='clear: both;'></div><div class='link_title'>Lien:</div><div class='link'><a href='#' onClick='openCenteredWindow(\""+pathurl+"\");'>"+pathname+"</a></div><div style='clear: both;'></div>";	
			}
			
			var searchFlag = true;
			
			for (z in topicsSearch) {
				if (search(topicsArray,topicsSearch[z])) {
					var searchFlag = true;
					break;
				} else {
					var searchFlag = false;
				}
			}
			
			if (searchFlag == true) {
				for (w in formatsSearch) {
					if (format===formatsSearch[w]) {
						var searchFlag = true;
						break;
					} else {
						var searchFlag = false;
					}
				}
			}
			
			if (searchFlag == true) {
				number++;
				htmlStringToAdd += 
					"<div class='resource' id='id_"+id+"'>" + 
						"<p>#" + number + ": <a href='#' onclick='changeState(\"box_"+id+"\", \"ec_"+id+"\");return false;'>"+name+"<img id='ec_"+id+"' src='images/arrow_collapse.gif' width='10' height='10' alt='Ouvrir' /></a></p>" +
						"<div class='answer' id='box_"+id+"'>" +
							"<div class='desc_title'>Description:</div><div class='desc'>"+desc+"</div><div style='clear: both;'></div><div class='topics_title'>Sujet(s):</div><div class='format'>"+topics+"</div><div style='clear: both;'></div><div class='format_title'>Type:</div><div class='format'>"+format+"</div><div style='clear: both;'></div>"+ linktotal +
						"</div>" +
					"</div>";
			}
		}
	}
	
	document.getElementById("resources_list").innerHTML = htmlStringToAdd;
	putLRTitle(number);
	
	if (document.getElementById("resources_list").innerHTML == "") {
		document.getElementById("lr_title").innerHTML += "<p>Aucune ressource de formation pour les critres slectionns.</p>";
	}
}		
function putLRTitle(number) {
	$("#lr_title").empty().append("<div class='lr_title id='lr_title'>Ressources de formation pour "+ usedRole +"</div><p>Diverses ressources de formation  l'appui des Blocs de comptences sont indiques ci-aprs. Pour choisir les ressources correspondant  un sujet particulier des Blocs de comptences, cliquez sur ce sujet et sur le type de ressource dans la colonne de gauche (aide-mmoire, sance de formation ou atelier, formation en ligne).</p><p>" + number + " ressource(s) trouve(s).</p>");
}

function showLoading(pct) {
	$("#lr_title").empty().append("<div class='lr_title' id='lr_title'>Chargement des ressources... Veuillez patienter. " + pct + "</div>");
	clearResources();
}

function clearResources() {
	$("#resources_list").empty();
}

function search(theArray, searchStr) {
	var returnArray = false;
	for (i=0; i<theArray.length; i++) {
		if (typeof(searchStr) == 'function') {
			if (searchStr.test(theArray[i])) {
				if (!returnArray) { returnArray = [] }
					returnArray.push(i);
			}
		} else {
			if (theArray[i]===searchStr) {
				if (!returnArray) { returnArray = [] }
					returnArray.push(i);
			}
		}
	}
	return returnArray;
}

function changeState(obj, image) {
	if (document.getElementById(obj).style.display == "block") {
		document.getElementById(obj).style.display = "none";
		document.getElementById(image).src = "images/arrow_collapse.gif";
		document.getElementById(image).alt = "Ouvrir";
	} else {
		document.getElementById(obj).style.display = "block";
		document.getElementById(image).src = "images/arrow_expand.gif";
		document.getElementById(image).alt = "Fermer";
	}
}